//Knowledgedump.org - HTML Checker

#ifndef HTML_CHECKER_H
#define HTML_CHECKER_H

#include <QTabWidget>
#include <QTextStream>
#include <QFileDialog>
#include <QMessageBox>
#include <QClipboard>
#include <QTextCharFormat>
#include <QTextCursor>


namespace Ui {
	class HTML_Checker;
}


class HTML_Checker : public QTabWidget
{
	Q_OBJECT	//Meta object compiler (moc) macro.


public:
	//Constructor & Destructor
	explicit HTML_Checker(QTabWidget *parent = nullptr);
	~HTML_Checker();

private slots:

	void on_addST_button_clicked();
	void on_addDT_button_clicked();
	void on_save_button_clicked();
	void on_load_button_clicked();
	void on_paste_button_clicked();
	void on_check_button_clicked();
	void on_removeST_button_clicked();
	void on_removeDT_button_clicked();
	void on_reset_button_clicked();
	void on_jump_button_clicked();

private:
	Ui::HTML_Checker *ui;
	void init();

	void clean_string(QString&);
	void clean_stringList(QStringList&);
	void removeMatches_stringList(QStringList&, QStringList&);

	bool is_close_tag(QString&);
	QString convert_to_close_tag(QString);

	bool check_string(QString&, int&);

	//Default values for the HTML single and double tag lists.
	QStringList st_defaultList;
	QStringList dt_defaultList;
	//Actually used lists.
	QStringList st_list;
	QStringList dt_list;

	//List that contains currently open tags (converted to close tags).
	QStringList prev_tags;
	//The boolean is used to exit the check_string recursion, if a missing tag was detected.
	bool exit_flag;

	//Members to set formatting and errors.
	int err_count;
	QTextCursor selection;
	QTextCharFormat comment_format;
	QTextCharFormat php_format;
	QTextCharFormat error_format;
	QTextCharFormat neutral_format;
	QTextCharFormat unknown_format;
	QVector<int> err_locations;
	int flag1, flag2;
};


#endif // HTML_CHECKER_H
